 ; Ŀ
 ;   Zeo: get stuff ready to block.                                        
 ;   Put attdefs and text on the text layer, colour bylayer, put           
 ;   everything else on zero, colour and linetype byblock.                 
 ;   Copyright 2007 by Rocket Software Ltd.                                
 ;                                                                         
 ; 
 (defun c:zeo (/ ss num entt colr lint)
  (command "undo" "be")
  (prompt "Select stuff to prepare for blocking: ")
  (setq ss (ssget))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq entt (entget enam))
         (setq num (1+ num))
 ; Ŀ
 ;   If the entity was text or an attdef, move it to the Text layer        
 ;   and colour it bylayer.                                                
 ; 
         (cond ((member (cdr (assoc 0 entt)) '("ATTDEF" "TEXT"))
                (entmod (setq entt (subst (cons 8 "text")
                                          (assoc 8 entt) entt)))
                (if (setq colr (assoc 62 entt))
                    (entmod (subst (cons 62 256) colr entt))))
 ; Ŀ
 ;   Else move it to 0 and colour and linetype byblock.                    
 ; 
               (t
                (entmod (setq entt (subst (cons 8 "0") (assoc 8 entt) entt)))
                (if (setq colr (assoc 62 entt))
                    (entmod (setq entt (subst (cons 62 0) colr entt)))
                    (entmod (setq entt (append entt (list (cons 62 0))))))
                (if (setq lint (assoc 6 entt))
                    (entmod (subst (cons 6 "byblock") lint entt))
                    (entmod (append entt (list (cons 6 "byblock"))))))))
  (command "undo" "end")
 (princ))